/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse vec4(0.0,0.0, 0.0,0.0)

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;
uniform sampler2D iChannel1;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract


/////////////////////////////////////////////////////////////////////////////////

// Created by Javier Barandiaran Martirena 2014
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

float noise( in vec2 x ){return texture2D(iChannel0, x).x;}

float fbm( vec2 p )
{
    float f = 0.50000*noise( p ); p = p*2.04;
    f += 0.25000*noise( p ); p = p*2.02;
    f += 0.12500*noise( p ); p = p*2.03;
    f += 0.06250*noise( p ); p = p*2.05;
    f += 0.03125*noise( p );

    return f/0.96875;
}

void main(void)
{
	vec2 uv = gl_FragCoord.xy / iResolution.xy;	
    vec2 distv = gl_FragCoord.xy - 0.5 * iResolution.xy;
    float dist = sqrt( dot( distv, distv ) );

    //remap coordinates between (-1,1)
    vec2 p = -1.0 + 2.0 * uv; 
    p.y *= iResolution.y / iResolution.x; //remove aspect ratio    
    
    //polar coordinates
    float r = sqrt( dot( p, p ) );
    float a = atan( p.y, p.x );
    //polar coordinates with 90 degrees rotation
    vec2 p2 = vec2( p.x*cos( 1.57 ) - p.y *sin( 1.57 ), p.y * cos( 1.57 ) + p.x * sin( 1.57 ) );    
    float a2 = atan( p2.y, p2.x );

    
    float irisRadius = iResolution.y*0.45;
    float irisGrad = iResolution.y*0.04;
    float pupilRadius = iResolution.y*0.15;
    float pupilGrad = iResolution.y*0.03;    
    float scleraRadius = iResolution.y*0.85;
    float scleraGrad = iResolution.y*0.1;
    
    // Calculate average frequency of the music
    float fftAvg = 0.0;
    float x = 0.0;
    for ( int i = 0; i < 10; ++ i)
    {
        float fft  = texture2D( iChannel1, vec2(x,0.25) ).x;
        x+=0.1;       
        fftAvg += fft;                
    }	
    float mul = 0.8+fftAvg * 0.15;
    
	// Modify pupil radius with the music
    pupilRadius *= mul;
    pupilGrad *= mul;    
    
    const vec3 irisColor = vec3(0.7,0.85,0.99);
    const vec3 irisColor2 = vec3(0.4,0.2,0.2);
    const vec3 irisColor3 = vec3(0.7,0.99,0.85);
    const vec3 irisColor4 = vec3(0.9,0.99,0.5);
    const vec3 scleraColor = vec3(0.98,0.95,0.98);
    
    float factor =  smoothstep( irisRadius*1.1, pupilRadius, dist );
    factor *= factor;
    float animIris = 1.0/mul;    
    //The internal radius of the iris should contract and dilate with the pupil
    //but the external radius remains fixed
    float f2 = fbm( vec2( (1.0-factor) * 0.5*r + factor*animIris*0.4*r, 0.2*a2) );
    float f3 = fbm( vec2( (1.0-factor) * 0.4*r + factor*animIris*0.2*r, 0.2*a2) );
    float f4 = fbm( vec2( (1.0-factor) * 0.2*r + factor*animIris*0.1*r,0.5+ 0.1*a2 ) );
    float f5 = fbm( vec2( (1.0-factor) * 0.4*r + factor*animIris*0.4*r, 0.5*a2 ) );
              
    vec3 col = mix( irisColor, vec3(0.1), f2 ); //blue
    vec3 col2 = mix( irisColor3, vec3(0.2), f2 ); //green
    vec3 col3 = mix( irisColor4, vec3(0.1), f2 ); //green
    //green in the center around the pupil
    col=mix( col, col2, smoothstep( 3.0*pupilRadius, 0.0, dist ) );
    //green spots
    col=mix( col, col2,smoothstep( 0.4, 0.6, ( f3 ) ) );
    //green spots
    col=mix( col, col3, 0.4*smoothstep( 0.4, 0.6, f4 ) );
    //white lines
    col=mix( col, vec3(1.0), 0.4*smoothstep( 0.3, 1.0, f5 ) );
     
    //darken the external perimeter of the iris
    col *= clamp( 0.6+smoothstep( irisRadius, 0.0, dist ), 0.0, 1.0 );

    //iris circle
    float f = smoothstep(irisRadius-irisGrad,irisRadius, dist );
    //sclera
    //red veins
    float f6 = smoothstep(0.49, 1.0, fbm( vec2( 0.5*r, a+fbm(0.07*p) ) ) );    
    vec3 scleraColor2 = mix( scleraColor, vec3(1.0,0.0,0.0), 0.3*f6 );
    //mix sclera and iris
    col = mix( col, scleraColor2, f );

    //eyeball
    //darken the external radius of the eyeball
    f = smoothstep(irisRadius,scleraRadius, dist );
    col = mix( col, 0.5*scleraColor, 0.4*f ); 
    //red corners
    f = smoothstep(scleraRadius-scleraGrad,scleraRadius, dist );    
    col = mix( col, vec3(0.8,0.0,0.0), 0.3*f ); 

    //pupil black circle
    f = 1.0 - smoothstep( pupilRadius- pupilGrad, pupilRadius, dist );
    col = mix( col, vec3(0.0), f );
    
    //Corneal reflections
    col += 0.4*smoothstep( 0.05, 0.0, length( p - vec2( 0.1, 0.1 ) ) );
    col += smoothstep( 0.3, 0.0, length( p - vec2( 0.2, 0.2 ) ) );
    col += 0.4*smoothstep( 0.2, 0.0, length( p - vec2( -0.2, -0.2 ) ) );
        
    //Eyelid
   	vec3 eyelidShadow = vec3( smoothstep( 0.0, 0.17, -0.4 - p.y + 0.4*p.x * p.x ) +
                smoothstep( 0.0, 0.17, -0.12 + p.y + 0.2*p.x * p.x ) );    
    vec3 eyelid = vec3( smoothstep( 0.0, 0.015, -0.5 - p.y + 0.4*p.x * p.x ) +
                smoothstep( 0.0, 0.015, -0.3 + p.y + 0.3*p.x * p.x ) );
	col = mix( col, vec3( 0.0, 0.0, 0.0 ), 0.7*eyelidShadow );
    col = mix( col, vec3( 0.79, 0.69, 0.69 ), eyelid );
	
    //darken the top of the image
    col *= 0.5 + 0.5 * pow(1.0-uv.y,0.4);
	gl_FragColor = vec4( col, 1.0 );
}